#include <bits/stdc++.h>
using namespace std;
using ll = long long;

void dfs(const vector<vector<int>> &graph, int current, int destination, vector<bool> &visited, vector<int> &currentPath, vector<int> &longestPath)
{
    visited[current] = true;        
    currentPath.push_back(current); 

    if (current == destination)
    {
        if (currentPath.size() > longestPath.size())
        {
            longestPath = currentPath; 
        }
    }
    else
    {
        for (int neighbor = 0; neighbor < graph.size(); neighbor++)
        {
            if (graph[current][neighbor] == 1 && !visited[neighbor])
            {
                dfs(graph, neighbor, destination, visited, currentPath, longestPath);
            }
        }
    }

    currentPath.pop_back(); 
    visited[current] = false; 
}

vector<int> findLongestPath(const vector<vector<int>> &graph, int start, int end)
{
    int n = graph.size();
    vector<bool> visited(n, false); 
    vector<int> currentPath;        
    vector<int> longestPath;        

    dfs(graph, start, end, visited, currentPath, longestPath);

    return longestPath;
}

int main()
{
    ios::sync_with_stdio(false);
    cin.tie(0);
    ll n, m, q, p;
    cin >> n >> m >> q >> p;
    vector<ll> A(n);
    vector<ll> helper;
    vector<vector<int>> graph(n);
    vector<ll> answers(q+1);
    for (auto &i : graph)
    {
        i.resize(n);
    }
    for (ll i = 0; i < n; i++)
    {
        cin >> A[i];
    }
    for (ll i = 0; i < m; i++)
    {
        ll u, v;
        cin >> u >> v;
        graph[u - 1][v - 1] = 1;
        graph[v - 1][u - 1] = 1;
    }
    for (ll i = 1; i < q + 1; i++)
    {
        ll a1, b1;
        cin >> a1 >> b1;
        ll a = (a1 + answers[i - 1] * p - 1) % n + 1;
        ll b = (b1 + answers[i - 1] * p - 1) % n + 1;
        vector<int> path = findLongestPath(graph, a - 1, b - 1);
        if (!path.empty())
        {
            for (int node : path)
            {
                helper.push_back(A[node]);
            }
            sort(helper.begin(), helper.end());

            if (helper.size() == 1)
            {
                answers[i] = helper[0];
            }
            else
            {
                if (helper.size() % 2 == 0)
                {
                    answers[i] = helper[helper.size() / 2 - 1];
                }
                else
                {
                    answers[i] = helper[helper.size() / 2];
                }
            }
        }
        helper.clear();
    }
}